<?php
/*------------------------------------------------------------------------
# youtubevimeoplayerfx.php - YouTube/Vimeo Player FX
# ------------------------------------------------------------------------
# author    FlashXML.net
# copyright Copyright (C) 2011 flashxml.net. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.flashxml.net
# Technical Support:  Forum - http://www.flashxml.net/youtube-vimeo-player.html#comments
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');
$youtubevimeoplayerfx_params = null;

$mainframe->registerEvent('onPrepareContent', 'plgcontentyoutubevimeoplayerfx');
$youtubevimeoplayerfx_embed_codes_count = 0;
$youtubevimeoplayerfx_swfobject_embedded = false;

function plgcontentyoutubevimeoplayerfx(&$row, &$params, $page=0) {
	if (is_object($row)) {
		return plgyoutubevimeoplayerfx($row->text, $params);
	}
	return plgyoutubevimeoplayerfx($row, $params);
}

function plgyoutubevimeoplayerfx(&$text, &$params) {
	if (JString::strpos($text, '{youtubevimeoplayerfx') === false) {
		return true;
	}

	global $youtubevimeoplayerfx_params;
	$youtubevimeoplayerfx_params = array(
		'embed_codes_count' => 0,
		'swfobject_embedded' => false,
		'wmode_values' => array(
			'allowed' => array('transparent', 'window'),
			'default' => 'transparent',
		),
		'regexp_match_keys' => array(
			'settings' => 2,
			'width' => 4,
			'height' => 6,
			'wmode' => 8,
			'alternative_text' => 9,
		),
	);

	$text = preg_replace_callback('|{youtubevimeoplayerfx(\s+settings=([^ ]+))?(\s+width=([0-9]+))?(\s+height=([0-9]+))?(\s+wmode=([a-z]+))?\s*}(.*){/youtubevimeoplayerfx}|i', 'plgyoutubevimeoplayerfxembedcode', $text);
	return true;
}

function plgyoutubevimeoplayerfxembedcode($params) {
	global $youtubevimeoplayerfx_params;

	$youtubevimeoplayerfx_plugin_helper = JPluginHelper::getPlugin('content', 'youtubevimeoplayerfx');
	$pluginParams = new JParameter($youtubevimeoplayerfx_plugin_helper->params);
	$youtubevimeoplayer_path = $pluginParams->get('youtubevimeoplayerfx_path');
	if (strpos($youtubevimeoplayer_path, '/') !== 0) {
		$youtubevimeoplayer_path = '/' . $youtubevimeoplayer_path;
		$pluginParams->def('youtubevimeoplayerfx_path', $path);
	}

	$settings = !empty($params[$youtubevimeoplayerfx_params['regexp_match_keys']['settings']]) ? $params[$youtubevimeoplayerfx_params['regexp_match_keys']['settings']] : 'settings.xml';

	global $youtubevimeoplayerfx_swfobject_embedded;
	if (empty($youtubevimeoplayerfx_swfobject_embedded)) {
		global $mainframe;
		$mainframe->addCustomHeadTag('<script type="text/javascript" src="http'.(!empty($_SERVER['HTTPS']) ? 's' : '').'://ajax.googleapis.com/ajax/libs/swfobject/2.2/swfobject.js"></script>');
		$youtubevimeoplayerfx_swfobject_embedded = true;
	}

	$youtubevimeoplayerfx_width = $youtubevimeoplayerfx_height = 0;

	switch (true) {
		case function_exists('simplexml_load_file') && file_exists(JPATH_SITE.$youtubevimeoplayer_path.$settings):
			$xml = simplexml_load_file(JPATH_SITE.$youtubevimeoplayer_path.$settings);
			if ($xml) {
				$youtubevimeoplayerfx_width_attributes_array = $xml->General_Properties->componentWidth->attributes();
				$youtubevimeoplayerfx_width = !empty($youtubevimeoplayerfx_width_attributes_array) ? (int)$youtubevimeoplayerfx_width_attributes_array['value'] : 0;
				$youtubevimeoplayerfx_height_attributes_array = $xml->General_Properties->componentHeight->attributes();
				$youtubevimeoplayerfx_height = !empty($youtubevimeoplayerfx_height_attributes_array) ? (int)$youtubevimeoplayerfx_height_attributes_array['value'] : 0;
			}
		break;

		case (int)$params[$youtubevimeoplayerfx_params['regexp_match_keys']['width']] > 0 && (int)$params[$youtubevimeoplayerfx_params['regexp_match_keys']['height']] > 0:
			$youtubevimeoplayerfx_width = (int)$params[$youtubevimeoplayerfx_params['regexp_match_keys']['width']];
			$youtubevimeoplayerfx_height = (int)$params[$youtubevimeoplayerfx_params['regexp_match_keys']['height']];
		break;

		default:
			return '<!-- invalid path to the settings XML file, please use valid plugin parameter values -->';
		break;
	}

	if (!($youtubevimeoplayerfx_width > 0 && $youtubevimeoplayerfx_height > 0)) {
		return '<!-- invalid YouTube/Vimeo Player FX width and / or height -->';
	}

	$youtubevimeoplayerfx_params['embed_codes_count']++;

	if (empty($params[$youtubevimeoplayerfx_params['regexp_match_keys']['wmode']])) {
		$youtubevimeoplayer_wmode = $pluginParams->get('youtubevimeoplayerfx_wmode');
		if (empty($youtubevimeoplayer_wmode)) {
			$youtubevimeoplayer_wmode = $youtubevimeoplayerfx_params['wmode_values']['default'];
		}
	} else {
		$youtubevimeoplayer_wmode = in_array($params[$youtubevimeoplayerfx_params['regexp_match_keys']['wmode']], $youtubevimeoplayerfx_params['wmode_values']['allowed']) ? $params[$youtubevimeoplayerfx_params['regexp_match_keys']['wmode']] : $youtubevimeoplayerfx_params['wmode_values']['default'];
	}

	$joomla_install_dir_in_url = rtrim(JURI::root(true), '/');
	if (!empty($joomla_install_dir_in_url) && strpos($joomla_install_dir_in_url, '/') !== 0) {
		$joomla_install_dir_in_url = '/' . $joomla_install_dir_in_url;
	}

	return '<div id="flashxmlyoutubevimeoplayer'.$youtubevimeoplayerfx_params['embed_codes_count'].'">'.$params[$youtubevimeoplayerfx_params['regexp_match_keys']['alternative_text']].'<a href="http://www.webmasters.by/articles/joomla/317-youtube-vimeo-player-for-joomla.html">download here</a></div><script type="text/javascript">'."swfobject.embedSWF('{$joomla_install_dir_in_url}{$youtubevimeoplayer_path}YouTubeVimeoPlayerFX.swf', 'flashxmlyoutubevimeoplayer{$youtubevimeoplayerfx_params['embed_codes_count']}', '{$youtubevimeoplayerfx_width}', '{$youtubevimeoplayerfx_height}', '9.0.0.0', '', { folderPath: '{$joomla_install_dir_in_url}{$youtubevimeoplayer_path}'".($settings != 'settings.xml' ? ", settingsXML: '{$settings}'" : '')." }, { scale: 'noscale', salign: 'tl', wmode: '{$youtubevimeoplayer_wmode}', allowScriptAccess: 'sameDomain', allowFullScreen: true }, {});</script>";
}
